<?php
/**
 * Template Name: Request Quote
 * Description: Secure quote intake with Sentra messaging.
 */
get_header();

$mc_phone = defined('MOORES_PHONE') ? MOORES_PHONE : '';
$portal_url = defined('SENTRA_PORTAL_URL') ? trim((string) SENTRA_PORTAL_URL) : '';
$quote_url = defined('SENTRA_QUOTE_URL') ? trim((string) SENTRA_QUOTE_URL) : '';
if (!$quote_url) $quote_url = $portal_url;
if (!$quote_url && function_exists('sentrasystems_config')) {
	$cfg = sentrasystems_config();
	if (is_array($cfg) && !empty($cfg['portal_url'])) {
		$quote_url = trim((string) $cfg['portal_url']);
	}
}

$ajax_url = function_exists('admin_url') ? admin_url('admin-ajax.php') : '';
$nonce = function_exists('wp_create_nonce') ? wp_create_nonce('moores_auth') : '';
$quote_href = $quote_url ? $quote_url : '#';
$quote_disabled = $quote_url ? '' : 'is-disabled';
?>

<section class="section" id="request-quote" data-quote-page data-ajax-url="<?php echo esc_url($ajax_url); ?>" data-nonce="<?php echo esc_attr($nonce); ?>">
	<div class="container">
		<div class="panel edge pad mc-quote-panel">
			<div class="mc-quote-header">
				<h1>Request a Quote</h1>
				<p class="lead">
					Start a secure conversation with Moore’s CustomZ. We’ll gather a few details, then a sales rep will take over for pricing and approvals.
				</p>
			</div>

			<div class="mc-quote-disclosure">
				<strong>AI assistance notice:</strong>
				<span>Initial responses may be AI-assisted to keep things moving. A human rep reviews everything before pricing or decisions.</span>
			</div>

			<div class="mc-quote-gate" data-quote-gate>
				<p class="lead">Please sign in to access secure messaging and request a quote.</p>
				<div class="mc-quote-actions">
					<button class="btn btn-primary" type="button" data-auth-open>Sign in to continue</button>
				</div>
			</div>

			<div class="mc-quote-content" data-quote-content hidden>
				<p class="mc-quote-user">Signed in as <strong data-quote-user>Client</strong></p>
				<div class="mc-quote-actions">
					<a class="btn btn-primary <?php echo esc_attr($quote_disabled); ?>" data-quote-link href="<?php echo esc_url($quote_href); ?>" target="_blank" rel="noopener">Open Secure Messaging</a>
					<button class="btn btn-outline" type="button" data-auth-open>Switch account</button>
				</div>
				<?php if (!$quote_url) : ?>
					<small class="mc-quote-note">Secure messaging is not configured yet. Please call <?php echo esc_html($mc_phone); ?>.</small>
				<?php else : ?>
					<small class="mc-quote-note">You’ll be routed into Sentra messaging. Replies may be AI-assisted until a sales rep joins.</small>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>

<script>
(() => {
	const host = document.querySelector('[data-quote-page]');
	if (!host) return;
	const gate = host.querySelector('[data-quote-gate]');
	const content = host.querySelector('[data-quote-content]');
	const userLabel = host.querySelector('[data-quote-user]');

	const getStoredPacket = () => {
		try {
			const raw = localStorage.getItem('sentra_auth_packet');
			if (!raw) return null;
			return JSON.parse(raw);
		} catch (e) {
			return null;
		}
	};

	const isPacketValid = (packet) => {
		if (!packet || !packet.expires_at) return false;
		const now = Math.floor(Date.now() / 1000);
		return packet.expires_at > now;
	};

	const applyState = (packet) => {
		const isValid = isPacketValid(packet);
		if (gate) gate.hidden = isValid;
		if (content) content.hidden = !isValid;
		if (userLabel) {
			userLabel.textContent = isValid ? (packet.email || packet.username || 'Client') : 'Client';
		}
	};

	applyState(getStoredPacket());

	window.addEventListener('sentra-auth-updated', (event) => {
		applyState(event?.detail?.packet || null);
	});

	window.addEventListener('focus', () => {
		if (document.hidden) return;
		applyState(getStoredPacket());
	});
})();
</script>

<?php get_footer(); ?>
